*************************************************************************
10/03/2012: CHANGED DEFAULT INDEX TO ADJ_RS, CHANGED GAP TO BE PER POOR 
			PERSON

11/4/2011: ADDED SY 2011 

8/9/2011: FIX BUG WHERE FAMILIES WEREN'T SORTED BY PERSON WITHIN A FAMILY 
		  WHEN USING FIRST.*.  THIS MATTERED FOR DATA STEPS NAS_POV3 AND NOS_POV4. 
		  IT ONLY AFFECTED A SMALL FRACTION OF OBS.  FIXED BUG BY SORTING BY PPOS IN 
		  ADDITION TO FAMID OR HSEQ.  VARIABLES AFFECTED: DEM_GRP, EMP_HEAD, ED_HEAD

4/30/2011: RE-RAN AFTER ADDING FSSINC_RR TO POVERTY**** FILES.  ADDED INC 9 AND 10

3/17/2011: RE-RAN AFTER ADDING TOT_TRANS TO POVERTY**** FILES.  CHANGED INC3
		   FROM AFTER-TAX USING CPS TAXES TO PRE-TAX, PRE-TRANSFER INCOME
		   ALSO, ADDED INC5 TO THE EFFECT OF DEMOG ANALYSIS
		   NOTE, IMPUTED BENEFITS FOR SY 2010 ARE AVAILABLE

12/28/2010: ADDED SRVY YEAR 2010, NOTE IMPUTED  BENEFITS STILL NOT AVAIL, AND 
			REMOVED CAP GAINS AND LOSSES FROM INCOME MEASURES 

2/24/2010: UPDATED THE DEMOGRAPHIC ANALYSIS AND STD ERRORS TO USE 2009 
		   INSTEAD OF 2006 SURVEY YEAR AS FINAL YEAR OF ANALYSIS

2/4/2010: STOPPED REFERRING TO 1980 THRESHOLDS CALCULATED IN SEPARATE FILE
	      AND CALCULATED WITHIN THIS PROGRAM INSTEAD.

		  ADDED SURVEY YEAR 2009.

11/12/2009: FIXED OFFICAL POVERTY GAP CALC, NO LONGER MULTIPLY BY SCALE

9/5/2009: ADDED 2007 & 2008 SURVEY YEARS

MAKE TOPCODING ADJUSTMENT FOR CPS TAXES ONLY, SO WON'T MATTER FOR TAXSIM

* FOR HOUSRET_ADJ, I USE THE AVERAGE OF THE INTEREST RATE FROM 1980-2005

9/3/2007:  ADDED ADJUSTED CPI-U-RS AND RELATIVE POVERTY MEASURES
9/10/2007:  ADDED INDICATOR FOR HAVING 65+ IN FAMILY AND POVGAP AND
			DEMOGRAPHIC MEANS.
1/9/2008:  ADDED 2006, CREATED MUTUALLY EXCLUSIVE DEMOGRAPHIC GROUPS--SEE
			WHERE I CREATE NAS_POV3 AND NAS_POV4
8/20/2008: I CHANGED INC7 FROM THE ONE WITH ADJUSTED HEQ TO ONE THAT INCLUDES ALL BUT HEQ, 
		   I.E. A MEASURE THAT INCLUDES EMPLOYER CONTRIBUTIONS TO HEALTH INSURANCE
  "Everything but annuitized home eqity is adjusted: money income + noncash benefits + adjusted he"
  *inc7=(ftotval_final+fmvfs_final-fts_tottax+fcapgain_final-fcaploss_final
     +fhoussub_final*12+fmvrsl_final+femcontrb_final+fngmcare_final+fngmcaid_final+housret_adj)/scale;
  *hinc7=(htotval+hmvfs-hts_tottax+hcapgain-hcaploss
     +hhoussub*12+hmvrsl+hemcontrb+hngmcare+hngmcaid+housret_adj)/hscale;

*3/2/2007:  PUT A FLOOR ON INCOME AT ZERO FOR CALCUALTING GAPS 
*************************************************************************;

**************************************************************
NOTE:  RUN 1981 FIRST TO CREATE THRESHOLDS FOR ANCHORING IN 1980 
USING SURVEY YEAR 1981.  
**************************************************************;

option obs=max mprint;

%macro nasrates8009(yr);

PROC SORT DATA=cpsdata.poverty&yr;
   BY famid ppos;
RUN;
data temp;
set cpsdata.poverty&yr(KEEP=famid mainjob ftype hseq fkind wkswrk age msupwgt);

IF &yr LE 1995 AND mainjob GE 99999 THEN tc=1;
   ELSE IF 1996 LE &yr LE 2002 AND mainjob GE 150000 THEN tc=1;
   ELSE IF 2003 LE &yr LE 2010 AND mainjob GE 200000 THEN tc=1;
   ELSE IF &yr GE 2011 AND mainjob GE 250000 THEN tc=1;
   ELSE tc=0;

emp=(wkswrk>0);
kid=(age LE 17);

KEEP famid tc ftype hseq fkind emp kid msupwgt;
RUN;

PROC MEANS SUM NOPRINT DATA=temp;
   BY famid;
   VAR tc emp kid msupwgt;
   OUTPUT OUT=tcdat SUM=tc_sum no_earnr no_kids famwgt;
RUN;

data temp;
MERGE temp tcdat(KEEP=famid tc_sum no_earnr no_kids famwgt);
BY famid;
IF FIRST.famid;
RUN;

DATA temp2;
SET temp(RENAME=(tc_sum=tc_sum2 no_earnr=no_earnr2 no_kids=no_kids2 famwgt=famwgt2));
* keep only primary families and related subfamilies;
IF (&yr GE 1988 AND ftype IN(1,3)) OR (&yr LE 1987 AND fkind IN(1,2));
KEEP hseq tc_sum2 no_earnr2 no_kids2 famwgt2;
RUN;
PROC SORT DATA=temp2;
   BY hseq;
RUN;
PROC MEANS SUM NOPRINT DATA=temp2;
   BY hseq;
   VAR tc_sum2 no_earnr2 no_kids2 famwgt2;
   OUTPUT OUT=tcdat2 SUM=;
RUN;

PROC SORT DATA=temp;
   BY hseq;
RUN;

DATA temp;
MERGE temp tcdat2(KEEP=hseq tc_sum2 no_earnr2 no_kids2 famwgt2);
BY hseq;
IF &yr GE 1988 THEN DO;
   IF ftype IN(2,4,5) AND tc_sum GT 0 THEN tc_final=1;
     ELSE IF ftype IN(1,3) AND tc_sum2 GT 0 THEN tc_final=1;
     ELSE tc_final=0;
   IF ftype IN(2,4,5) THEN tot_earnrs=no_earnr;
     ELSE IF ftype IN(1,3) THEN tot_earnrs=no_earnr2;
   IF ftype IN(2,4,5) THEN tot_kids=no_kids;
     ELSE IF ftype IN(1,3) THEN tot_kids=no_kids2;     
   IF ftype IN(2,4,5) THEN famwgt_final=famwgt;
     ELSE IF ftype IN(1,3) THEN famwgt_final=famwgt2;    
END;
IF &yr LE 1987 THEN DO;
   IF fkind IN(3,4,5) AND tc_sum GT 0 THEN tc_final=1;
     ELSE IF fkind IN(1,2) AND tc_sum2 GT 0 THEN tc_final=1;
     ELSE tc_final=0;
   IF fkind IN(3,4,5) THEN tot_earnrs=no_earnr;
     ELSE IF fkind IN(1,2) THEN tot_earnrs=no_earnr2;
   IF fkind IN(3,4,5) THEN tot_kids=no_kids;
     ELSE IF fkind IN(1,2) THEN tot_kids=no_kids2;
   IF fkind IN(3,4,5) THEN famwgt_final=famwgt;
     ELSE IF fkind IN(1,2) THEN famwgt_final=famwgt2;
END;

KEEP famid tc_final tot_earnrs tot_kids famwgt_final;
RUN;

PROC SORT DATA=temp;
   BY famid;
RUN;

data nas_pov1 nas_pov2;
set cpsdata.poverty&yr(KEEP=age ftype fkind hseq famid);

IF age GE 65;

IF (ftype IN(1,3) AND &yr GE 1988) 
   OR (fkind IN(1,2) AND &yr LE 1987) THEN OUTPUT nas_pov1;
IF (ftype IN(2,4,5) AND &yr GE 1988) 
   OR (fkind GE 3 AND &yr LE 1987) THEN OUTPUT nas_pov2;

KEEP hseq famid;
RUN;

PROC SORT DATA=nas_pov1;
   BY hseq;
RUN;
PROC SORT DATA=nas_pov2;
   BY famid;
RUN;

DATA nas_pov1;
   SET nas_pov1;
   BY hseq;
   IF first.hseq;
RUN;
DATA nas_pov2;
   SET nas_pov2;
   BY famid;
   IF first.famid;
RUN;

PROC SORT DATA=cpsdata.poverty&yr;
   BY hseq;
RUN;

DATA nas_pov;
   MERGE cpsdata.poverty&yr(IN=in1) nas_pov1(IN=in2);
   BY hseq;

   IF in2 THEN pot64_prime=1;
      ELSE pot64_prime=0;
RUN;

PROC SORT DATA=nas_pov;
   BY famid;
RUN;

DATA nas_pov;
   MERGE nas_pov(IN=in1) nas_pov2(IN=in3) temp;
   BY famid;
   IF in1;

   IF in3 THEN pot64_notprime=1;
      ELSE pot64_notprime=0;

IF &yr GE 1988 AND FIRST.famid AND ftype IN(1,2,4,5) THEN povhead=1;
   ELSE IF &yr LE 1987 AND FIRST.famid AND fkind IN(1,3,4,5) THEN povhead=1;
ELSE povhead=0;

IF (ftype IN(1,3) AND &yr GE 1988) 
   OR (fkind IN(1,2) AND &yr LE 1987) THEN persot64=pot64_prime;
   ELSE IF (ftype IN(2,4,5) AND &yr GE 1988) 
   OR (fkind GE 3 AND &yr LE 1987) THEN persot64=pot64_notprime;
RUN;



data nas_pov3 nas_pov4;
set nas_pov(KEEP=age ftype fkind hseq famid tot_kids marstat hgc hga wkswrk ppos);

IF (ftype IN(1,3) AND &yr GE 1988) 
   OR (fkind IN(1,2) AND &yr LE 1987) THEN OUTPUT nas_pov3;
IF (ftype IN(2,4,5) AND &yr GE 1988) 
   OR (fkind GE 3 AND &yr LE 1987) THEN OUTPUT nas_pov4;

RUN;

PROC SORT DATA=nas_pov3;
   BY hseq ppos;
RUN;
PROC SORT DATA=nas_pov4;
   BY famid ppos;
RUN;

DATA nas_pov3;
   SET nas_pov3;
   BY hseq ppos;
   IF first.hseq;

emp_hd_prime=(wkswrk>0);

IF &yr GE 1992 THEN DO;
  IF age LE 64 AND tot_kids GT 0 AND marstat IN (4,5,6,7) THEN dem_grp_prime=1;
   ELSE IF age LE 64 AND tot_kids GT 0 AND marstat IN (1,2,3) THEN dem_grp_prime=2;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (4,5,6,7) THEN dem_grp_prime=3;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (1,2,3) THEN dem_grp_prime=4;
   ELSE IF age GE 65 THEN dem_grp_prime=5;

   IF hga LT 39 THEN ed_hd_prime=1;
      ELSE IF hga=39 THEN ed_hd_prime=2;
      ELSE IF 40 LE hga LE 42 THEN ed_hd_prime=3;
      ELSE IF hga GE 43 THEN ed_hd_prime=4;
END;

IF 1988 LE &yr LE 1991 THEN DO;
  IF age LE 64 AND tot_kids GT 0 AND marstat IN (4,5,6,7) THEN dem_grp_prime=1;
   ELSE IF age LE 64 AND tot_kids GT 0 AND marstat IN (1,2,3) THEN dem_grp_prime=2;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (4,5,6,7) THEN dem_grp_prime=3;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (1,2,3) THEN dem_grp_prime=4;
   ELSE IF age GE 65 THEN dem_grp_prime=5;

  IF hga LE 11 OR (hga=12 AND hgc NE 1) THEN ed_hd_prime=1;
      ELSE IF hga=12 AND hgc=1 THEN ed_hd_prime=2;
      ELSE IF 13 LE hga LE 15 OR (hga=16 AND hgc NE 1) THEN ed_hd_prime=3;
      ELSE IF hga GT 16 OR (hga=16 AND hgc=1) THEN ed_hd_prime=4;
END;

IF &yr LE 1987 THEN DO;
  IF age LE 64 AND tot_kids GT 0 AND marstat IN (5,6,7,8) THEN dem_grp_prime=1;
   ELSE IF age LE 64 AND tot_kids GT 0 AND marstat IN (1,2,3,4) THEN dem_grp_prime=2;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (5,6,7,8) THEN dem_grp_prime=3;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (1,2,3,4) THEN dem_grp_prime=4;
   ELSE IF age GE 65 THEN dem_grp_prime=5;

   IF hga LE 12 OR (hga=13 AND hgc NE 1) THEN ed_hd_prime=1;
      ELSe IF hga=13 AND hgc=1 THEN ed_hd_prime=2;
      ELSE IF 14 LE hga LE 16 OR (hga=17 AND hgc NE 1) THEN ed_hd_prime=3;
      ELSE IF hga GT 17 OR (hga=17 AND hgc=1) THEN ed_hd_prime=4;
END;

RUN;

DATA nas_pov4;
   SET nas_pov4;
   BY famid ppos;
   IF first.famid;

emp_hd_nprime=(wkswrk>0);

IF &yr GE 1992 THEN DO;
  IF age LE 64 AND tot_kids GT 0 AND marstat IN (4,5,6,7) THEN dem_grp_nprime=1;
   ELSE IF age LE 64 AND tot_kids GT 0 AND marstat IN (1,2,3) THEN dem_grp_nprime=2;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (4,5,6,7) THEN dem_grp_nprime=3;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (1,2,3) THEN dem_grp_nprime=4;
   ELSE IF age GE 65 THEN dem_grp_nprime=5;

   IF hga LT 39 THEN ed_hd_nprime=1;
      ELSE IF hga=39 THEN ed_hd_nprime=2;
      ELSE IF 40 LE hga LE 42 THEN ed_hd_nprime=3;
      ELSE IF hga GE 43 THEN ed_hd_nprime=4;
END;

IF 1988 LE &yr LE 1991 THEN DO;
  IF age LE 64 AND tot_kids GT 0 AND marstat IN (4,5,6,7) THEN dem_grp_nprime=1;
   ELSE IF age LE 64 AND tot_kids GT 0 AND marstat IN (1,2,3) THEN dem_grp_nprime=2;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (4,5,6,7) THEN dem_grp_nprime=3;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (1,2,3) THEN dem_grp_nprime=4;
   ELSE IF age GE 65 THEN dem_grp_nprime=5;

  IF hga LE 11 OR (hga=12 AND hgc NE 1) THEN ed_hd_nprime=1;
      ELSE IF hga=12 AND hgc=1 THEN ed_hd_nprime=2;
      ELSE IF 13 LE hga LE 15 OR (hga=16 AND hgc NE 1) THEN ed_hd_nprime=3;
      ELSE IF hga GT 16 OR (hga=16 AND hgc=1) THEN ed_hd_nprime=4;
END;

IF &yr LE 1987 THEN DO;
  IF age LE 64 AND tot_kids GT 0 AND marstat IN (5,6,7,8) THEN dem_grp_nprime=1;
   ELSE IF age LE 64 AND tot_kids GT 0 AND marstat IN (1,2,3,4) THEN dem_grp_nprime=2;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (5,6,7,8) THEN dem_grp_nprime=3;
   ELSE IF age LE 64 AND tot_kids=0 AND marstat IN (1,2,3,4) THEN dem_grp_nprime=4;
   ELSE IF age GE 65 THEN dem_grp_nprime=5;

   IF hga LE 12 OR (hga=13 AND hgc NE 1) THEN ed_hd_nprime=1;
      ELSe IF hga=13 AND hgc=1 THEN ed_hd_nprime=2;
      ELSE IF 14 LE hga LE 16 OR (hga=17 AND hgc NE 1) THEN ed_hd_nprime=3;
      ELSE IF hga GT 17 OR (hga=17 AND hgc=1) THEN ed_hd_nprime=4;
END;

RUN;

PROC SORT DATA=nas_pov;
   BY hseq;
RUN;

DATA nas_pov;
   MERGE nas_pov(IN=in1) nas_pov3(IN=in2 KEEP=hseq dem_grp_prime ed_hd_prime emp_hd_prime);
   BY hseq;
   IF in1;
RUN;

PROC SORT DATA=nas_pov;
   BY famid;
RUN;

DATA nas_pov;
   MERGE nas_pov(IN=in1) nas_pov4(IN=in3 KEEP=famid dem_grp_nprime ed_hd_nprime emp_hd_nprime) temp;
   BY famid;
   IF in1;

IF (ftype IN(1,3) AND &yr GE 1988) OR (fkind IN(1,2) AND &yr LE 1987) THEN DO;
	dem_grp=dem_grp_prime;
	ed_head=ed_hd_prime;
	emp_head=emp_hd_prime;
END;
IF (ftype IN(2,4,5) AND &yr GE 1988) OR (fkind GE 3 AND &yr LE 1987) THEN DO;
	dem_grp=dem_grp_nprime;
	ed_head=ed_hd_nprime;
	emp_head=emp_hd_nprime;
END;

DROP dem_grp_nprime ed_hd_nprime emp_hd_nprime dem_grp_prime ed_hd_prime emp_hd_prime;

IF 0 LE age LE 17 THEN age1=1;
      ELSE age1=0;
   IF 18 LE age LE 64 THEN age2=1;
      ELSE age2=0;
   IF age GE 65 THEN age3=1;
   ELSE age3=0;

IF 0 LE age LE 17 THEN age_grp=1;
   ELSE IF 18 LE age LE 64 THEN age_grp=2;
   ELSE IF age GE 65 THEN age_grp=3;

IF 2003 LE year LE 2011 THEN DO;
   IF race2=1 AND reorgn=0 THEN r1=1;
      ELSE r1=0;
     IF race2=2 AND reorgn=0 THEN r2=1;
	 ELSE r2=0;
     r3=1-r1-r2;
END;

IF 1988 LE year LE 2002 THEN DO;
   IF race2=1 AND reorgn GE 8 THEN r1=1;
      ELSE r1=0;
     IF race2=2 AND reorgn GE 8 THEN r2=1;
	 ELSE r2=0;
     r3=1-r1-r2;
END;

IF 1976 LE year LE 1987 THEN DO;
   IF race2=1 AND reorgn GE 30 THEN r1=1;
      ELSE r1=0;
     IF race2=2 AND reorgn GE 30 THEN r2=1;
	 ELSE r2=0;
     r3=1-r1-r2;
END;

IF r1=1 THEN race_head=1;
  ELSE IF r2=1 THEN race_head=2;
  ELSE race_head=3;

ARRAY fam(1:5);
  DO t=1 TO 5;
     IF dem_grp=t THEN fam(t)=1;
       ELSE fam(t)=0; 
  END; 
ARRAY ed(1:4);
  DO t=1 TO 4;
     IF ed_head=t THEN ed(t)=1;
       ELSE ed(t)=0; 
END; 

ARRAY region(1:4);
   DO t=1 to 4;
	IF hreg=t THEN region(t)=1;
	ELSE region(t)=0;
END;

dem_group2=10*dem_grp+ed_head;
dem_group3=10*dem_grp+race_head; 
dem_group4=10*dem_grp+hreg;
dem_group5=100*dem_grp+10*ed_head+emp_head; 

IF htenure=1 THEN ownhome=1;
   ELSE ownhome=0;

IF tc_final=1 THEN ftottax_final2=0.21*ftotval_final;
   ELSE ftottax_final2=ftottax_final;


scale=(fpersons_final-tot_kids+.7*tot_kids)**.7;
hscale=(hpersons-hrelu18+.7*hrelu18)**.7;
*official;
inc1=ftotval_final/scale;
hinc1=htotval/hscale;
*after-tax(TAXSIM);
inc2=(ftotval_final-fts_tottax)/scale;
hinc2=(htotval-hts_tottax)/hscale;
*NOTE: CHANGED INC3 TO PRE-TRANSFER INC, SEE POVERTY RESULTS: ALL_TABLES65.XLS OR EARLIER
 FOR RESULTS FOR AFTER-TAX MEASURE USING CPS TAXES;
*after-tax;
*inc3=(ftotval_final-ftottax_final2)/scale;
*hinc3=(htotval-htottax)/hscale;

*pre-tax, pre-transfer: offical-(soc security+wc+ui+vet+ssi+afdc/tanf);
inc3=(ftotval_final-ftot_trans_final)/scale;
hinc3=(htotval-htot_trans)/hscale;
*official+foodstamps+taxes;
inc4=(ftotval_final+fmvfs_final-fts_tottax)/scale;
hinc4=(htotval+hmvfs-hts_tottax)/hscale;
*official+foodstamps+taxes+other noncash;
inc5=(ftotval_final+fmvfs_final-fts_tottax
     +fhoussub_final*12+fmvrsl_final)/scale;
hinc5=(htotval+hmvfs-hts_tottax
     +hhoussub*12+hmvrsl)/hscale;
*official+foodstamps+taxes+other noncash+medical;
inc6=(ftotval_final+fmvfs_final-fts_tottax
     +fhoussub_final*12+fmvrsl_final+fngmcare_final+fngmcaid_final)/scale;
hinc6=(htotval+hmvfs-hts_tottax
     +hhoussub*12+hmvrsl+hngmcare+hngmcaid)/hscale;
*Everything but annuitized home eqity (inc6 plus employer contrib to health ins);
inc7=(ftotval_final+fmvfs_final-fts_tottax
     +fhoussub_final*12+fmvrsl_final+femcontrb_final+fngmcare_final+fngmcaid_final)/scale;
hinc7=(htotval+hmvfs-hts_tottax
     +hhoussub*12+hmvrsl+hemcontrb+hngmcare+hngmcaid)/hscale;
*Everything: money income + noncash benefits + annuitized home equity;
inc8=(ftotval_final+fmvfs_final-fts_tottax
     +fhoussub_final*12+fmvrsl_final+femcontrb_final+housret+fngmcare_final+fngmcaid_final)/scale;
hinc8=(htotval+hmvfs-hts_tottax
     +hhoussub*12+hmvrsl+hemcontrb+housret+hngmcare+hngmcaid)/hscale;
*pre-tax, pre-social security: offical-(soc security);
inc9=(ftotval_final-fssinc_rr_final)/scale;
hinc9=(htotval-hssinc_rr)/hscale;
*pre-tax, pre-non soc. sec transfers: offical-(wc+ui+vet+ssi+afdc/tanf);
inc10=(ftotval_final-ftot_trans_final+fssinc_rr_final)/scale;
hinc10=(htotval-htot_trans+hssinc_rr)/hscale;

RUN;

PROC MEANS DATA=nas_pov MEDIAN; 
  VAR inc1-inc10 hinc1-hinc10;
  WEIGHT msupwgt;
  OUTPUT OUT=median_&yr MEDIAN=med_inc1-med_inc10 med_hinc1-med_hinc10;
RUN;

PROC SORT DATA=nas_pov;
   BY ref_year;
RUN;

DATA nas_pov;
MERGE nas_pov(IN=in1) cexpov.prices1980(RENAME=(year=ref_year));
BY ref_year;
IF in1;
RUN;

PROC UNIVARIATE DATA=nas_pov NOPRINT;
   VAR inc1 inc2 inc3 inc4 inc5 inc6 inc7 inc8 inc9 inc10 hinc1 hinc2 hinc3 hinc4 hinc5 hinc6 hinc7 hinc8 hinc9 hinc10;
   WHERE ref_year=1980;
   WEIGHT msupwgt;
   OUTPUT OUT=tholds&yr 
   		pctlpts=13.0
		pctlpre=inc1_ inc2_ inc3_ inc4_ inc5_ inc6_ inc7_ inc8_ inc9_ inc10_
				hinc1_ hinc2_ hinc3_ hinc4_ hinc5_ hinc6_ hinc7_ hinc8_ hinc9_ hinc10_ 
		pctlname=p13_0;
RUN;

data nas_pov;
   IF _N_=1 THEN SET tholds1981
		(KEEP=inc1_p13_0 inc2_p13_0 inc3_p13_0 inc4_p13_0 inc5_p13_0 inc6_p13_0 
			  inc7_p13_0 inc8_p13_0 inc9_p13_0 inc10_p13_0
			  hinc1_p13_0 hinc2_p13_0 hinc3_p13_0 hinc4_p13_0 hinc5_p13_0 hinc6_p13_0 hinc7_p13_0 
			  hinc8_p13_0 hinc9_p13_0 hinc10_p13_0);
   IF _N_=1 THEN SET median_&yr(KEEP=med_inc1-med_inc10 med_hinc1-med_hinc10);
   SET nas_pov;

IF 1988 LE &yr LE 1999 then do;
   if ftotval_final<fpovcut then pov1=1;
   else  pov1=0;
   if ftotval_final<fpovcut*1.5 then pov150=1;
   else  pov150=0;

   gap_official=povhead*((max(0,fpovcut-ftotval_final))*msupwgt/100); 
end;
IF 1980 LE &yr LE 1987 OR 2000 LE &yr LE 2011 then do;
   if ftotval_final<fpovcut_final then pov1=1;
   else  pov1=0;
   if ftotval_final<fpovcut_final*1.5 then pov150=1;
   else  pov150=0;

   gap_official=povhead*((max(0,fpovcut_final-MAX(0,ftotval_final)))*msupwgt/100); 
end;

pov_gap_official = pov1*msupwgt/100;   


   ARRAY pov_cpi_(1:10);
   ARRAY pov_pce_(1:10);
   ARRAY pov_cpi150_(1:10);
   ARRAY pov_cpi_adj150_(1:10);
   ARRAY pov_cpi75_(1:10);
   ARRAY pov_pce75_(1:10);
   ARRAY pov_cpi50_(1:10);
   ARRAY pov_cpi_adj50_(1:10);
   ARRAY pov_cpi25_(1:10);
   ARRAY pov_cpi_adj_(1:10);
   ARRAY pov_cpiu_(1:10);
   ARRAY med_pov_(1:10);

   ARRAY gap_cpi_(1:10);
   ARRAY gap_pce_(1:10);
   ARRAY gap_cpi75_(1:10);
   ARRAY gap_pce75_(1:10);
   ARRAY gap_cpi50_(1:10);
   ARRAY gap_cpi_adj50_(1:10);
   ARRAY gap_cpi25_(1:10);
   ARRAY gap_cpiu_(1:10);
   ARRAY gap_cpi_adj_(1:10);

    ARRAY pov_gap_cpi_(1:10);
    ARRAY pov_gap_pce_(1:10);
    ARRAY pov_gap_cpi75_(1:10);
    ARRAY pov_gap_pce75_(1:10);
    ARRAY pov_gap_cpi50_(1:10);
    ARRAY pov_gap_cpi_adj50_(1:10);
    ARRAY pov_gap_cpi25_(1:10);
    ARRAY pov_gap_cpiu_(1:10);
    ARRAY pov_gap_cpi_adj_(1:10);


   ARRAY inctemp(1:10) inc1-inc10;
   ARRAY thresh(1:10) inc1_p13_0 inc2_p13_0 inc3_p13_0 inc4_p13_0 inc5_p13_0 inc6_p13_0 inc7_p13_0 inc8_p13_0
					  inc9_p13_0 inc10_p13_0;
   ARRAY med_temp(1:10) med_inc1-med_inc10;

   ARRAY hpov_cpi_(1:10);
   ARRAY hpov_pce_(1:10);
   ARRAY hpov_cpi150_(1:10);
   ARRAY hpov_cpi_adj150_(1:10);
   ARRAY hpov_cpi75_(1:10);
   ARRAY hpov_pce75_(1:10);
   ARRAY hpov_cpi50_(1:10);
   ARRAY hpov_cpi_adj50_(1:10);
   ARRAY hpov_cpi25_(1:10);
   ARRAY hpov_cpi_adj_(1:10);
   ARRAY med_hpov_(1:10);

   ARRAY hinctemp(1:10) hinc1-hinc10;
   ARRAY hthresh(1:10) hinc1_p13_0 hinc2_p13_0 hinc3_p13_0 hinc4_p13_0 
					  hinc5_p13_0 hinc6_p13_0 hinc7_p13_0 hinc8_p13_0 hinc9_p13_0 hinc10_p13_0;
   ARRAY hmed_temp(1:10) med_hinc1-med_hinc10;

   do t=1 to 10;
	IF inctemp(t) GE thresh(t)*cpi THEN pov_cpi_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*cpi THEN pov_cpi_(t)=1; 

    IF inctemp(t) GE thresh(t)*pce THEN pov_pce_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*pce THEN pov_pce_(t)=1; 

	IF inctemp(t) GE thresh(t)*cpi*1.5 THEN pov_cpi150_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*cpi*1.5 THEN pov_cpi150_(t)=1; 

    IF inctemp(t) GE thresh(t)*cpiurs_adj*1.5 THEN pov_cpi_adj150_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*cpiurs_adj*1.5 THEN pov_cpi_adj150_(t)=1; 

    IF inctemp(t) GE thresh(t)*cpi*0.75 THEN pov_cpi75_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*cpi*0.75 THEN pov_cpi75_(t)=1; 

    IF inctemp(t) GE thresh(t)*pce*0.75 THEN pov_pce75_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*pce*0.75 THEN pov_pce75_(t)=1; 

	IF inctemp(t) GE thresh(t)*cpi*0.50 THEN pov_cpi50_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*cpi*0.50 THEN pov_cpi50_(t)=1; 

    IF inctemp(t) GE thresh(t)*cpiurs_adj*0.50 THEN pov_cpi_adj50_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*cpiurs_adj*0.50 THEN pov_cpi_adj50_(t)=1; 

	IF inctemp(t) GE thresh(t)*cpi*0.25 THEN pov_cpi25_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*cpi*0.25 THEN pov_cpi25_(t)=1; 

    IF inctemp(t) GE thresh(t)*cpiurs_adj THEN pov_cpi_adj_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*cpiurs_adj THEN pov_cpi_adj_(t)=1; 

	IF inctemp(t) GE thresh(t)*cpiu THEN pov_cpiu_(t)=0;
    ELSE IF inctemp(t) LT thresh(t)*cpiu THEN pov_cpiu_(t)=1; 

	IF inctemp(t) GE med_temp(t)*0.5 THEN med_pov_(t)=0;
    ELSE IF inctemp(t) LT med_temp(t)*0.5 THEN med_pov_(t)=1; 

*  using resources at the household level;
	IF hinctemp(t) GE hthresh(t)*cpi THEN hpov_cpi_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*cpi THEN hpov_cpi_(t)=1; 

    IF hinctemp(t) GE hthresh(t)*pce THEN hpov_pce_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*pce THEN hpov_pce_(t)=1; 

	IF hinctemp(t) GE hthresh(t)*cpi*1.5 THEN hpov_cpi150_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*cpi*1.5 THEN hpov_cpi150_(t)=1; 

    IF hinctemp(t) GE hthresh(t)*cpiurs_adj*1.5 THEN hpov_cpi_adj150_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*cpiurs_adj*1.5 THEN hpov_cpi_adj150_(t)=1; 

    IF hinctemp(t) GE hthresh(t)*cpi*0.75 THEN hpov_cpi75_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*cpi*0.75 THEN hpov_cpi75_(t)=1; 

    IF hinctemp(t) GE hthresh(t)*pce*0.75 THEN hpov_pce75_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*pce*0.75 THEN hpov_pce75_(t)=1; 

	IF hinctemp(t) GE hthresh(t)*cpi*0.50 THEN hpov_cpi50_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*cpi*0.50 THEN hpov_cpi50_(t)=1; 

    IF hinctemp(t) GE hthresh(t)*cpiurs_adj*0.50 THEN hpov_cpi_adj50_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*cpiurs_adj*0.50 THEN hpov_cpi_adj50_(t)=1; 

	IF hinctemp(t) GE hthresh(t)*cpi*0.25 THEN hpov_cpi25_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*cpi*0.25 THEN hpov_cpi25_(t)=1; 

    IF hinctemp(t) GE hthresh(t)*cpiurs_adj THEN hpov_cpi_adj_(t)=0;
    ELSE IF hinctemp(t) LT hthresh(t)*cpiurs_adj THEN hpov_cpi_adj_(t)=1; 

	IF hinctemp(t) GE hmed_temp(t)*0.5 THEN med_hpov_(t)=0;
    ELSE IF hinctemp(t) LT hmed_temp(t)*0.5 THEN med_hpov_(t)=1; 


   gap_cpi_(t)=povhead*((max(0,(thresh(t)*cpi)-MAX(0,inctemp(t))))*msupwgt*scale/100); 
   gap_pce_(t)=povhead*((max(0,(thresh(t)*pce)-MAX(0,inctemp(t))))*msupwgt*scale/100); 
   gap_cpiu_(t)=povhead*((max(0,(thresh(t)*cpiu)-MAX(0,inctemp(t))))*msupwgt*scale/100); 

   gap_cpi75_(t)=povhead*((max(0,(thresh(t)*cpi*0.75)-MAX(0,inctemp(t))))*msupwgt*scale/100); 
   gap_pce75_(t)=povhead*((max(0,(thresh(t)*pce*0.75)-MAX(0,inctemp(t))))*msupwgt*scale/100); 

   gap_cpi50_(t)=povhead*((max(0,(thresh(t)*cpi*0.50)-MAX(0,inctemp(t))))*msupwgt*scale/100); 
   gap_cpi_adj50_(t)=povhead*((max(0,(thresh(t)*cpiurs_adj*0.50)-MAX(0,inctemp(t))))*msupwgt*scale/100); 

   gap_cpi25_(t)=povhead*((max(0,(thresh(t)*cpi*0.25)-MAX(0,inctemp(t))))*msupwgt*scale/100); 
   
   gap_cpi_adj_(t)=povhead*((max(0,(thresh(t)*cpiurs_adj)-MAX(0,inctemp(t))))*msupwgt*scale/100); 

    pov_gap_cpi_(t)= pov_cpi_(t)*msupwgt/100;   
    pov_gap_pce_(t)= pov_pce_(t)*msupwgt/100;
    pov_gap_cpi75_(t)= pov_cpi75_(t)*msupwgt/100;
    pov_gap_pce75_(t)= pov_pce75_(t)*msupwgt/100; 
    pov_gap_cpi50_(t)= pov_cpi50_(t)*msupwgt/100; 		
    pov_gap_cpi_adj50_(t)= pov_cpi_adj50_(t)*msupwgt/100; 
    pov_gap_cpi25_(t)= pov_cpi25_(t)*msupwgt/100; 
    pov_gap_cpiu_(t)= pov_cpiu_(t)*msupwgt/100; 
    pov_gap_cpi_adj_(t)= pov_cpi_adj_(t)*msupwgt/100; 

end;

RUN;

data nas_pov&yr;
SET nas_pov(KEEP=pov1 pov_cpi_1 pov_cpi_8 pov_cpi_2 pov_cpi_5 pov_cpi_adj_1 pov_cpi_adj_2 pov_cpi_adj_8 pov_cpi_adj_5 age1-age3 r1-r3 region1-region4 
				 fam1-fam5 year ref_year msupwgt ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final
				 dem_grp dem_group2 dem_group3 dem_group4 dem_group5);
RUN;
PROC FREQ DATA=nas_pov&yr;
   TABLE dem_grp / out=out_1_&yr; 
   WEIGHT msupwgt;
RUN; 
PROC FREQ DATA=nas_pov&yr;
   TABLE dem_group2 / out=out_2_&yr;
   WEIGHT msupwgt; 
RUN;
PROC FREQ DATA=nas_pov&yr; 
   TABLE dem_group3 / out=out_3_&yr;
   WEIGHT msupwgt;
RUN; 
PROC FREQ DATA=nas_pov&yr; 
   TABLE dem_group4 / out=out_4_&yr; 
   WEIGHT msupwgt; 
RUN; 
PROC FREQ DATA=nas_pov&yr; 
   TABLE dem_group5 / out=out_5_&yr; 
   WEIGHT msupwgt; 
RUN; 

PROC MEANS DATA=nas_pov; 
      VAR pov1 pov150 pov_cpi_1-pov_cpi_10 pov_pce_1-pov_pce_10
	   pov_cpi150_1-pov_cpi150_10 pov_cpi_adj150_1-pov_cpi_adj150_10
	   pov_cpi75_1-pov_cpi75_10 pov_pce75_1-pov_pce75_10
	   pov_cpi50_1-pov_cpi50_10 pov_cpi_adj50_1-pov_cpi_adj50_10
	   pov_cpi25_1-pov_cpi25_10 pov_cpi_adj_1-pov_cpi_adj_10
	   pov_cpiu_1-pov_cpiu_10

	   hpov_cpi_1-hpov_cpi_10 hpov_pce_1-hpov_pce_10
	   hpov_cpi150_1-hpov_cpi150_10 hpov_cpi_adj150_1-hpov_cpi_adj150_10
	   hpov_cpi75_1-hpov_cpi75_10 hpov_pce75_1-hpov_pce75_10
	   hpov_cpi50_1-hpov_cpi50_10 hpov_cpi_adj50_1-hpov_cpi_adj50_10
	   hpov_cpi25_1-hpov_cpi25_10 hpov_cpi_adj_1-hpov_cpi_adj_10

	   med_pov_1-med_pov_10 med_hpov_1-med_hpov_10
;
   WEIGHT msupwgt;
   output out=pov&yr MEAN=;
RUN;

PROC MEANS DATA=nas_pov; 
	WHERE povhead=1;
	VAR pov1 pov150 pov_cpi_1 pov_cpi_2 pov_cpi_8 
       pov_cpi_adj_1 pov_cpi_adj_2 pov_cpi_adj_8;
    WEIGHT famwgt_final;
    OUTPUT OUT=pov_se_&yr MEAN= STDERR=se1-se8;
RUN;

PROC SORT DATA=nas_pov; 
  BY dem_grp;
RUN;
 
PROC MEANS DATA=nas_pov; 
  BY dem_grp;
      VAR pov1 pov150 pov_cpi_1-pov_cpi_10 pov_pce_1-pov_pce_10
	   pov_cpi150_1-pov_cpi150_10 pov_cpi_adj150_1-pov_cpi_adj150_10
	   pov_cpi75_1-pov_cpi75_10 pov_pce75_1-pov_pce75_10
	   pov_cpi50_1-pov_cpi50_10 pov_cpi_adj50_1-pov_cpi_adj50_10
	   pov_cpi25_1-pov_cpi25_10 pov_cpi_adj_1-pov_cpi_adj_10
	   pov_cpiu_1-pov_cpiu_10

	   hpov_cpi_1-hpov_cpi_10 hpov_pce_1-hpov_pce_10
	   hpov_cpi150_1-hpov_cpi150_10 hpov_cpi_adj150_1-hpov_cpi_adj150_10
	   hpov_cpi75_1-hpov_cpi75_10 hpov_pce75_1-hpov_pce75_10
	   hpov_cpi50_1-hpov_cpi50_10 hpov_cpi_adj50_1-hpov_cpi_adj50_10
	   hpov_cpi25_1-hpov_cpi25_10 hpov_cpi_adj_1-hpov_cpi_adj_10

	   med_pov_1-med_pov_10 med_hpov_1-med_hpov_10
;
   WEIGHT msupwgt;
   output out=povdem&yr MEAN=;
RUN;

PROC MEANS DATA=nas_pov; 
  BY dem_grp;
	WHERE povhead=1;
	VAR pov1 pov150 pov_cpi_1 pov_cpi_2 pov_cpi_8 
       pov_cpi_adj_1 pov_cpi_adj_2 pov_cpi_adj_8;
    WEIGHT famwgt_final;
    OUTPUT OUT=povdem_se_&yr MEAN= STDERR=se1-se8;
RUN;

PROC MEANS SUM DATA=nas_pov; 

      VAR  gap_official gap_cpi_1-gap_cpi_10 gap_pce_1-gap_pce_10 
           gap_cpi75_1-gap_cpi75_10 gap_pce75_1-gap_pce75_10  
           gap_cpi50_1-gap_cpi50_10 gap_cpi_adj50_1-gap_cpi_adj50_10
           gap_cpi25_1-gap_cpi25_10  
           gap_cpiu_1-gap_cpiu_10 gap_cpi_adj_1-gap_cpi_adj_10 
            
           pov_gap_official pov_gap_cpi_1-pov_gap_cpi_10 pov_gap_pce_1-pov_gap_pce_10 
           pov_gap_cpi75_1-pov_gap_cpi75_10 pov_gap_pce75_1-pov_gap_pce75_10
           pov_gap_cpi50_1-pov_gap_cpi50_10 pov_gap_cpi_adj50_1-pov_gap_cpi_adj50_10
           pov_gap_cpi25_1-pov_gap_cpi25_10 
           pov_gap_cpiu_1-pov_gap_cpiu_10
           pov_gap_cpi_adj_1-pov_gap_cpi_adj_10;
   output out=gap_all&yr SUM=;
RUN;

PROC MEANS SUM DATA=nas_pov; 
  BY dem_grp;

      VAR  gap_official gap_cpi_1-gap_cpi_10 gap_pce_1-gap_pce_10 
           gap_cpi75_1-gap_cpi75_10 gap_pce75_1-gap_pce75_10  
           gap_cpi50_1-gap_cpi50_10 gap_cpi_adj50_1-gap_cpi_adj50_10
           gap_cpi25_1-gap_cpi25_10 
           gap_cpiu_1-gap_cpiu_10 gap_cpi_adj_1-gap_cpi_adj_10 
            
           pov_gap_official pov_gap_cpi_1-pov_gap_cpi_10 pov_gap_pce_1-pov_gap_pce_10 
           pov_gap_cpi75_1-pov_gap_cpi75_10 pov_gap_pce75_1-pov_gap_pce75_10
           pov_gap_cpi50_1-pov_gap_cpi50_10 pov_gap_cpi_adj50_1-pov_gap_cpi_adj50_10
           pov_gap_cpi25_1-pov_gap_cpi25_10 
           pov_gap_cpiu_1-pov_gap_cpiu_10
           pov_gap_cpi_adj_1-pov_gap_cpi_adj_10;
   output out=gapdem&yr SUM=;
RUN;

PROC SORT DATA=nas_pov; 
  BY hreg;
RUN;
PROC MEANS DATA=nas_pov NOPRINT; 
  BY hreg;
      VAR pov1 pov_cpi_1 pov_cpi_2 pov_cpi_6;
   WEIGHT msupwgt;
   output out=povreg&yr MEAN=;
RUN;

PROC SORT DATA=nas_pov; 
  BY age_grp;
RUN;
PROC MEANS DATA=nas_pov NOPRINT; 
  BY age_grp;
      VAR pov1 pov_cpi_1 pov_cpi_2 pov_cpi_6;
   WEIGHT msupwgt;
   output out=povage&yr MEAN=;
RUN;

PROC SORT DATA=nas_pov; 
  BY hreg age_grp;
RUN;
PROC MEANS DATA=nas_pov NOPRINT; 
  BY hreg age_grp;
      VAR pov1 pov_cpi_1 pov_cpi_2 pov_cpi_6;
   WEIGHT msupwgt;
   output out=povreg_age&yr MEAN=;
RUN;

PROC SORT DATA=nas_pov; 
  BY hreg dem_grp;
RUN;
PROC MEANS DATA=nas_pov NOPRINT; 
  BY hreg dem_grp;
      VAR pov1 pov_cpi_1 pov_cpi_2 pov_cpi_6;
   WEIGHT msupwgt;
   output out=povreg_dem&yr MEAN=;
RUN;

%mend;


* RUN 1981 FIRST TO GET THRESHOLDS;
%nasrates8009(1981);


* CREATE PERMANENT SAS DATASET SO THESE THRESHOLDS CAN BE USED FOR nas_pov6479;
DATA cpsdata.tholds81;
SET tholds1981;
RUN;

*%nasrates8009(1991);
*%nasrates8009(2001);
*%nasrates8009(2009);


%nasrates8009(1980);
%nasrates8009(1982);
%nasrates8009(1983);
%nasrates8009(1984);
%nasrates8009(1985);
%nasrates8009(1986);
%nasrates8009(1987);
%nasrates8009(1988);
%nasrates8009(1989);
%nasrates8009(1990);
%nasrates8009(1991);
%nasrates8009(1992);
%nasrates8009(1993);
%nasrates8009(1994);
%nasrates8009(1995);
%nasrates8009(1996);
%nasrates8009(1997);
%nasrates8009(1998);
%nasrates8009(1999);
%nasrates8009(2000);
%nasrates8009(2001);
%nasrates8009(2002);
%nasrates8009(2003);
%nasrates8009(2004);
%nasrates8009(2005);
%nasrates8009(2006);
%nasrates8009(2007);
%nasrates8009(2008);
%nasrates8009(2009);
%nasrates8009(2010);
%nasrates8009(2011);

filename outfile1 'N:\Private\Poverty Trends\SAS\cps\output\nasrates8011.dat';
filename outfile2 'N:\Private\Poverty Trends\SAS\cps\output\nasratesh8011.dat';

DATA _null_; 
   SET  pov1980 pov1981 pov1982 pov1983 pov1984 pov1985 pov1986 pov1987 
		pov1988 pov1989 pov1990 pov1991 pov1992 pov1993 pov1994 pov1995 pov1996
		pov1997 pov1998 pov1999 pov2000 pov2001 pov2002 pov2003 pov2004 pov2005 pov2006
		pov2007 pov2008 pov2009 pov2010 pov2011;

FILE outfile1 lrecl=2500 pad; 
   PUT pov1 pov150 pov_cpi_1-pov_cpi_10 pov_pce_1-pov_pce_10
	   pov_cpi150_1-pov_cpi150_10 pov_cpi_adj150_1-pov_cpi_adj150_10
	   pov_cpi75_1-pov_cpi75_10 pov_pce75_1-pov_pce75_10
	   pov_cpi50_1-pov_cpi50_10 pov_cpi_adj50_1-pov_cpi_adj50_10 
	   pov_cpi25_1-pov_cpi25_10 pov_cpi_adj_1-pov_cpi_adj_10 
	   pov_cpiu_1-pov_cpiu_10 med_pov_1-med_pov_10; 
RUN; 

DATA _null_; 
   SET  pov1980 pov1981 pov1982 pov1983 pov1984 pov1985 pov1986 pov1987 
		pov1988 pov1989 pov1990 pov1991 pov1992 pov1993 pov1994 pov1995 pov1996
		pov1997 pov1998 pov1999 pov2000 pov2001 pov2002 pov2003 pov2004 pov2005 pov2006
		pov2007 pov2008 pov2009 pov2010 pov2011;

FILE outfile2 lrecl=1500 pad; 
   PUT hpov_cpi_1-hpov_cpi_8 hpov_pce_1-hpov_pce_8
	   hpov_cpi150_1-hpov_cpi150_8 hpov_cpi_adj150_1-hpov_cpi_adj150_8
	   hpov_cpi75_1-hpov_cpi75_8 hpov_pce75_1-hpov_pce75_8
	   hpov_cpi50_1-hpov_cpi50_8 hpov_cpi_adj50_1-hpov_cpi_adj50_8
	   hpov_cpi25_1-hpov_cpi25_8 hpov_cpi_adj_1-hpov_cpi_adj_8 med_hpov_1-med_hpov_8; 
RUN; 

filename outfile3 'N:\Private\Poverty Trends\SAS\cps\output\nasrates_dem_8011.dat';
filename outfile4 'N:\Private\Poverty Trends\SAS\cps\output\povgaps_8011.dat';
filename outfile5 'N:\Private\Poverty Trends\SAS\cps\output\medians_8011.dat';

DATA _null_; 
   SET  povdem1980 povdem1981 povdem1982 povdem1983 povdem1984 povdem1985 povdem1986 povdem1987 
		povdem1988 povdem1989 povdem1990 povdem1991 povdem1992 povdem1993 povdem1994 povdem1995 povdem1996
		povdem1997 povdem1998 povdem1999 povdem2000 povdem2001 povdem2002 povdem2003 povdem2004 povdem2005 
		povdem2006 povdem2007 povdem2008 povdem2009 povdem2010 povdem2011;

FILE outfile3 lrecl=1500 pad; 
   PUT dem_grp pov1 pov150 pov_cpi_1-pov_cpi_8 pov_pce_1-pov_pce_8
	   pov_cpi150_1-pov_cpi150_8 pov_cpi_adj150_1-pov_cpi_adj150_8
	   pov_cpi75_1-pov_cpi75_8 pov_pce75_1-pov_pce75_8
	   pov_cpi50_1-pov_cpi50_8 pov_cpi_adj50_1-pov_cpi_adj50_8 
	   pov_cpi25_1-pov_cpi25_8 pov_cpi_adj_1-pov_cpi_adj_8 
	   pov_cpiu_1-pov_cpiu_8 med_pov_1-med_pov_8; 
RUN; 


DATA _null_; 
   SET gap_all1980 gap_all1981 gap_all1982 gap_all1983 gap_all1984 gap_all1985 gap_all1986 gap_all1987 
	   gap_all1988 gap_all1989 gap_all1990 gap_all1991 gap_all1992 gap_all1993 gap_all1994 gap_all1995 
	   gap_all1996 gap_all1997 gap_all1998 gap_all1999 gap_all2000 gap_all2001 gap_all2002 gap_all2003 
	   gap_all2004 gap_all2005 gap_all2006 gap_all2007 gap_all2008 gap_all2009 gap_all2010 gap_all2011 

	   gapdem1980 gapdem1981 gapdem1982 gapdem1983 gapdem1984 gapdem1985 gapdem1986 gapdem1987 
	   gapdem1988 gapdem1989 gapdem1990 gapdem1991 gapdem1992 gapdem1993 gapdem1994 gapdem1995 gapdem1996
	   gapdem1997 gapdem1998 gapdem1999 gapdem2000 gapdem2001 gapdem2002 gapdem2003 gapdem2004 gapdem2005
	   gapdem2006 gapdem2007 gapdem2008 gapdem2009 gapdem2010 gapdem2011
;
   FILE outfile4 lrecl=2000 pad;
   PUT dem_grp gap_official gap_cpi_1-gap_cpi_8 gap_pce_1-gap_pce_8
           gap_cpi75_1-gap_cpi75_8 gap_pce75_1-gap_pce75_8
           gap_cpi50_1-gap_cpi50_8 gap_cpi_adj50_1-gap_cpi_adj50_8
           gap_cpi25_1-gap_cpi25_8 
           gap_cpiu_1-gap_cpiu_8 gap_cpi_adj_1-gap_cpi_adj_8 /
 
       dem_grp pov_gap_official pov_gap_cpi_1-pov_gap_cpi_8 pov_gap_pce_1-pov_gap_pce_8
           pov_gap_cpi75_1-pov_gap_cpi75_8 pov_gap_pce75_1-pov_gap_pce75_8
           pov_gap_cpi50_1-pov_gap_cpi50_8 pov_gap_cpi_adj50_1-pov_gap_cpi_adj50_8
           pov_gap_cpi25_1-pov_gap_cpi25_8 
           pov_gap_cpiu_1-pov_gap_cpiu_8
           pov_gap_cpi_adj_1-pov_gap_cpi_adj_8;
RUN;

DATA _null_; 
   SET median_1980 median_1981 median_1982 median_1983 median_1984 median_1985 median_1986 median_1987
	median_1988 median_1989 median_1990 median_1991 median_1992 median_1993 median_1994 median_1995
	median_1996 median_1997 median_1998 median_1999 median_2000 median_2001 median_2002 median_2003
	median_2004 median_2005 median_2006 median_2007 median_2008 median_2009 median_2010 median_2011; 
   FILE outfile5 lrecl=800 pad;
   PUT med_inc1-med_inc8 med_hinc1-med_hinc8;
RUN; 

****************************************************************
DATA FOR STANDARD ERRORS
CURRENTLY ONLY RAN FOR 10 YR INTERVALS, EDIT THIS WHEN RUN ALL YEARS
****************************************************************;
FILENAME outfil16 'N:\Private\Poverty Trends\SAS\cps\output\cps_w_se.dat';

DATA _null_; 
   SET pov_se_1981 pov_se_1991 pov_se_2001 pov_se_2011
		povdem_se_1981 povdem_se_1991 povdem_se_2001 povdem_se_2011;

*   SET pov_se_1980 pov_se_1981 pov_se_1982 pov_se_1983 pov_se_1984 pov_se_1985 
		pov_se_1986 pov_se_1987 pov_se_1988 pov_se_1989 pov_se_1990 pov_se_1991 
		pov_se_1992 pov_se_1993 pov_se_1994 pov_se_1995 pov_se_1996
		pov_se_1997 pov_se_1998 pov_se_1999 pov_se_2000 pov_se_2001 
		pov_se_2002 pov_se_2003 pov_se_2004 pov_se_2005 pov_se_2006
		povdem_se_1980 povdem_se_1981 povdem_se_1982 povdem_se_1983 povdem_se_1984 povdem_se_1985 
		povdem_se_1986 povdem_se_1987 povdem_se_1988 povdem_se_1989 povdem_se_1990 povdem_se_1991 
		povdem_se_1992 povdem_se_1993 povdem_se_1994 povdem_se_1995 povdem_se_1996
		povdem_se_1997 povdem_se_1998 povdem_se_1999 povdem_se_2000 povdem_se_2001 
		povdem_se_2002 povdem_se_2003 povdem_se_2004 povdem_se_2005 povdem_se_2006;
   FILE outfil16 lrecl=1500 pad; 
   PUT dem_grp pov1 pov150 pov_cpi_1 pov_cpi_2 pov_cpi_8 pov_cpi_adj_1 pov_cpi_adj_2 pov_cpi_adj_8
	   se1-se8;
RUN; 


****************************************************************
RESULTS FOR POVERTY AND MACRO CONDITIONS PAPER
****************************************************************;
FILENAME outfil20 'N:\Private\Poverty and Macro Conditions\SAS output\pov8010.dat';
FILENAME outfil21 'N:\Private\Poverty and Macro Conditions\SAS output\povdem8010.dat';
FILENAME outfil22 'N:\Private\Poverty and Macro Conditions\SAS output\povreg8010.dat';
FILENAME outfil23 'N:\Private\Poverty and Macro Conditions\SAS output\povage8010.dat';
FILENAME outfil24 'N:\Private\Poverty and Macro Conditions\SAS output\povreg_dem8010.dat';
FILENAME outfil25 'N:\Private\Poverty and Macro Conditions\SAS output\povreg_age8010.dat';

DATA _NULL_; 
   SET  pov1980 pov1981 pov1982 pov1983 pov1984 pov1985 pov1986 pov1987 
		pov1988 pov1989 pov1990 pov1991 pov1992 pov1993 pov1994 pov1995 pov1996
		pov1997 pov1998 pov1999 pov2000 pov2001 pov2002 pov2003 pov2004 pov2005 pov2006
		pov2007 pov2008 pov2009 pov2010;
   FILE outfil20 lrecl=1500 pad; 
   PUT pov1 pov_cpi_1 pov_cpi_2 pov_cpi_6; 
RUN; 
DATA _null_; 
   SET  povdem1980 povdem1981 povdem1982 povdem1983 povdem1984 povdem1985 povdem1986 povdem1987 
		povdem1988 povdem1989 povdem1990 povdem1991 povdem1992 povdem1993 povdem1994 povdem1995 povdem1996
		povdem1997 povdem1998 povdem1999 povdem2000 povdem2001 povdem2002 povdem2003 povdem2004 povdem2005 
		povdem2006 povdem2007 povdem2008 povdem2009 povdem2010;
   FILE outfil21 lrecl=1500 pad; 
   PUT dem_grp pov1 pov_cpi_1 pov_cpi_2 pov_cpi_6; 
RUN; 
DATA _NULL_; 
   SET  povreg1980 povreg1981 povreg1982 povreg1983 povreg1984 povreg1985 povreg1986 povreg1987 
		povreg1988 povreg1989 povreg1990 povreg1991 povreg1992 povreg1993 povreg1994 povreg1995 povreg1996
		povreg1997 povreg1998 povreg1999 povreg2000 povreg2001 povreg2002 povreg2003 povreg2004 povreg2005 
		povreg2006 povreg2007 povreg2008 povreg2009 povreg2010;
   FILE outfil22 lrecl=1500 pad; 
   PUT hreg pov1 pov_cpi_1 pov_cpi_2 pov_cpi_6; 
RUN; 
DATA _NULL_; 
   SET  povage1980 povage1981 povage1982 povage1983 povage1984 povage1985 povage1986 povage1987 
		povage1988 povage1989 povage1990 povage1991 povage1992 povage1993 povage1994 povage1995 povage1996
		povage1997 povage1998 povage1999 povage2000 povage2001 povage2002 povage2003 povage2004 povage2005 
		povage2006 povage2007 povage2008 povage2009 povage2010;
   FILE outfil23 lrecl=1500 pad; 
   PUT age_grp pov1 pov_cpi_1 pov_cpi_2 pov_cpi_6; 
RUN; 
DATA _NULL_; 
   SET  povreg_dem1980 povreg_dem1981 povreg_dem1982 povreg_dem1983 povreg_dem1984 povreg_dem1985 povreg_dem1986 povreg_dem1987 
		povreg_dem1988 povreg_dem1989 povreg_dem1990 povreg_dem1991 povreg_dem1992 povreg_dem1993 povreg_dem1994 povreg_dem1995 povreg_dem1996
		povreg_dem1997 povreg_dem1998 povreg_dem1999 povreg_dem2000 povreg_dem2001 povreg_dem2002 povreg_dem2003 povreg_dem2004 povreg_dem2005 
		povreg_dem2006 povreg_dem2007 povreg_dem2008 povreg_dem2009 povreg_dem2010;
   FILE outfil24 lrecl=1500 pad; 
   PUT hreg dem_grp pov1 pov_cpi_1 pov_cpi_2 pov_cpi_6; 
RUN; 
DATA _NULL_; 
   SET  povreg_age1980 povreg_age1981 povreg_age1982 povreg_age1983 povreg_age1984 povreg_age1985 povreg_age1986 povreg_age1987 
		povreg_age1988 povreg_age1989 povreg_age1990 povreg_age1991 povreg_age1992 povreg_age1993 povreg_age1994 povreg_age1995 povreg_age1996
		povreg_age1997 povreg_age1998 povreg_age1999 povreg_age2000 povreg_age2001 povreg_age2002 povreg_age2003 povreg_age2004 povreg_age2005 
		povreg_age2006 povreg_age2007 povreg_age2008 povreg_age2009 povreg_age2010;
   FILE outfil25 lrecl=1500 pad; 
   PUT hreg age_grp pov1 pov_cpi_1 pov_cpi_2 pov_cpi_6; 
RUN; 


****************************************************************
DEMOGRAPHICS
****************************************************************;

************************
POVERTY FOR BASE YR=2010
************************;

PROC SORT DATA=nas_pov2011;
   BY dem_grp; 
RUN; 
PROC MEANS DATA=nas_pov2011;
   BY dem_grp; 
   VAR pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5;
   WEIGHT msupwgt;  
   OUTPUT OUT=pd1_10 MEAN=;
RUN; 
PROC SORT DATA=nas_pov2011;
   BY dem_group2; 
RUN; 
PROC MEANS DATA=nas_pov2011;
   BY dem_group2; 
   VAR pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5;
   WEIGHT msupwgt;  
   OUTPUT OUT=pd2_10 MEAN=;
RUN; 
PROC SORT DATA=nas_pov2011;
   BY dem_group3;
RUN; 
PROC MEANS DATA=nas_pov2011;
   BY dem_group3;
   VAR pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5; 
   WEIGHT msupwgt;
   OUTPUT OUT=pd3_10 MEAN=;
RUN; 
PROC SORT DATA=nas_pov2011;  
   BY dem_group4;
RUN; 
PROC MEANS DATA=nas_pov2011;
   BY dem_group4;
   VAR pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5; 
   WEIGHT msupwgt;  
   OUTPUT OUT=pd4_10 MEAN=;
RUN; 
PROC SORT DATA=nas_pov2011;  
   BY dem_group5;
RUN; 
PROC MEANS DATA=nas_pov2011;
   BY dem_group5;
   VAR pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5; 
   WEIGHT msupwgt; 
   OUTPUT OUT=pd5_10 MEAN=;
RUN; 

************************
POVERTY FOR BASE YR=1980
************************;

PROC SORT DATA=nas_pov1981;
   BY dem_grp; 
RUN; 
PROC MEANS DATA=nas_pov1981;
   BY dem_grp; 
   VAR pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5;
   WEIGHT msupwgt;  
   OUTPUT OUT=pd1_80 MEAN=;
RUN; 
PROC SORT DATA=nas_pov1981;
   BY dem_group2; 
RUN; 
PROC MEANS DATA=nas_pov1981;
   BY dem_group2; 
   VAR pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5;
   WEIGHT msupwgt;  
   OUTPUT OUT=pd2_80 MEAN=;
RUN; 
PROC SORT DATA=nas_pov1981;
   BY dem_group3;
RUN; 
PROC MEANS DATA=nas_pov1981;
   BY dem_group3;
   VAR pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5; 
   WEIGHT msupwgt;
   OUTPUT OUT=pd3_80 MEAN=;
RUN; 
PROC SORT DATA=nas_pov1981;  
   BY dem_group4;
RUN; 
PROC MEANS DATA=nas_pov1981;
   BY dem_group4;
   VAR pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5; 
   WEIGHT msupwgt;  
   OUTPUT OUT=pd4_80 MEAN=;
RUN; 
PROC SORT DATA=nas_pov1981;  
   BY dem_group5;
RUN; 
PROC MEANS DATA=nas_pov1981;
   BY dem_group5;
   VAR pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5; 
   WEIGHT msupwgt; 
   OUTPUT OUT=pd5_80 MEAN=;
RUN; 

********************************************
THE SAME IS DONE FOR 1972 IN NAS_POV7279.SAS
AND RESULTS ARE STORED AS PERMANENT SAS 
DATASETS
********************************************;
* 1963;
PROC SORT DATA=cpsdata.out_1_1964; 
   BY dem_grp; 
RUN; 
DATA pd1_1963; 
   MERGE cpsdata.out_1_1964(KEEP=dem_grp percent)
         cpsdata.pd1_72(KEEP=dem_grp pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd1_80(KEEP=dem_grp pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd1_10(KEEP=dem_grp pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_grp; 

   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd1_1963; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem1_1963 MEAN=;
RUN; 
PROC SORT DATA=cpsdata.out_2_1964; 
   BY dem_group2; 
RUN; 
DATA pd2_1963; 
   MERGE cpsdata.out_2_1964(KEEP=dem_group2 percent)
         cpsdata.pd2_72(KEEP=dem_group2 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd2_80(KEEP=dem_group2 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd2_10(KEEP=dem_group2 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
BY dem_group2; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd2_1963; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem2_1963 MEAN=;
RUN; 
PROC SORT DATA=cpsdata.out_3_1964; 
   BY dem_group3; 
RUN; 
DATA pd3_1963; 
   MERGE cpsdata.out_3_1964(KEEP=dem_group3 percent)
         cpsdata.pd3_72(KEEP=dem_group3 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd3_80(KEEP=dem_group3 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd3_10(KEEP=dem_group3 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group3; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd3_1963; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem3_1963 MEAN=;
RUN; 
PROC SORT DATA=cpsdata.out_4_1964; 
   BY dem_group4; 
RUN; 
DATA pd4_1963; 
   MERGE cpsdata.out_4_1964(KEEP=dem_group4 percent)
         cpsdata.pd4_72(KEEP=dem_group4 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd4_80(KEEP=dem_group4 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd4_10(KEEP=dem_group4 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group4; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd4_1963; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem4_1963 MEAN=;
RUN; 
PROC SORT DATA=cpsdata.out_5_1964; 
   BY dem_group5; 
RUN; 
DATA pd5_1963; 
   MERGE cpsdata.out_5_1964(KEEP=dem_group5 percent)
         cpsdata.pd5_72(KEEP=dem_group5 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd5_80(KEEP=dem_group5 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd5_10(KEEP=dem_group5 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group5; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd5_1963; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem5_1963 MEAN=;
RUN; 


* 1972;
PROC SORT DATA=cpsdata.out_1_1973; 
   BY dem_grp; 
RUN; 
DATA pd1_1972; 
   MERGE cpsdata.out_1_1973(KEEP=dem_grp percent)
         cpsdata.pd1_72(KEEP=dem_grp pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd1_80(KEEP=dem_grp pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd1_10(KEEP=dem_grp pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_grp; 

   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd1_1972; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem1_1972 MEAN=;
RUN; 
PROC SORT DATA=cpsdata.out_2_1973; 
   BY dem_group2; 
RUN; 
DATA pd2_1972; 
   MERGE cpsdata.out_2_1973(KEEP=dem_group2 percent)
         cpsdata.pd2_72(KEEP=dem_group2 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd2_80(KEEP=dem_group2 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd2_10(KEEP=dem_group2 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group2; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd2_1972; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem2_1972 MEAN=;
RUN; 
PROC SORT DATA=cpsdata.out_3_1973; 
   BY dem_group3; 
RUN; 
DATA pd3_1972; 
   MERGE cpsdata.out_3_1973(KEEP=dem_group3 percent)
         cpsdata.pd3_72(KEEP=dem_group3 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd3_80(KEEP=dem_group3 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd3_10(KEEP=dem_group3 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group3; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd3_1972; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem3_1972 MEAN=;
RUN; 
PROC SORT DATA=cpsdata.out_4_1973; 
   BY dem_group4; 
RUN; 
DATA pd4_1972; 
   MERGE cpsdata.out_4_1973(KEEP=dem_group4 percent)
         cpsdata.pd4_72(KEEP=dem_group4 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd4_80(KEEP=dem_group4 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd4_10(KEEP=dem_group4 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group4; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd4_1972; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem4_1972 MEAN=;
RUN; 
PROC SORT DATA=cpsdata.out_5_1973; 
   BY dem_group5; 
RUN; 
DATA pd5_1972; 
   MERGE cpsdata.out_5_1973(KEEP=dem_group5 percent)
         cpsdata.pd5_72(KEEP=dem_group5 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd5_80(KEEP=dem_group5 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd5_10(KEEP=dem_group5 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group5; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd5_1972; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem5_1972 MEAN=;
RUN; 

* 1980;
PROC SORT DATA=out_1_1981; 
   BY dem_grp; 
RUN; 
DATA pd1_1980; 
   MERGE out_1_1981(KEEP=dem_grp percent)
         cpsdata.pd1_72(KEEP=dem_grp pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd1_80(KEEP=dem_grp pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd1_10(KEEP=dem_grp pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_grp; 

   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd1_1980; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem1_1980 MEAN=;
RUN; 
PROC SORT DATA=out_2_1981; 
   BY dem_group2; 
RUN; 
DATA pd2_1980; 
   MERGE out_2_1981(KEEP=dem_group2 percent)
         cpsdata.pd2_72(KEEP=dem_group2 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd2_80(KEEP=dem_group2 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd2_10(KEEP=dem_group2 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group2; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd2_1980; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem2_1980 MEAN=;
RUN; 
PROC SORT DATA=out_3_1981; 
   BY dem_group3; 
RUN; 
DATA pd3_1980; 
   MERGE out_3_1981(KEEP=dem_group3 percent)
         cpsdata.pd3_72(KEEP=dem_group3 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd3_80(KEEP=dem_group3 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd3_10(KEEP=dem_group3 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group3; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd3_1980; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem3_1980 MEAN=;
RUN; 
PROC SORT DATA=out_4_1981; 
   BY dem_group4; 
RUN; 
DATA pd4_1980; 
   MERGE out_4_1981(KEEP=dem_group4 percent)
         cpsdata.pd4_72(KEEP=dem_group4 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd4_80(KEEP=dem_group4 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd4_10(KEEP=dem_group4 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group4; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd4_1980; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem4_1980 MEAN=;
RUN; 
PROC SORT DATA=out_5_1981; 
   BY dem_group5; 
RUN; 
DATA pd5_1980; 
   MERGE out_5_1981(KEEP=dem_group5 percent)
         cpsdata.pd5_72(KEEP=dem_group5 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd5_80(KEEP=dem_group5 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd5_10(KEEP=dem_group5 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group5; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd5_1980; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem5_1980 MEAN=;
RUN; 

* 1990;
PROC SORT DATA=out_1_1991; 
   BY dem_grp; 
RUN; 
DATA pd1_1990; 
   MERGE out_1_1991(KEEP=dem_grp percent)
         cpsdata.pd1_72(KEEP=dem_grp pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd1_80(KEEP=dem_grp pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd1_10(KEEP=dem_grp pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_grp; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd1_1990; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem1_1990 MEAN=;
RUN; 
PROC SORT DATA=out_2_1991; 
   BY dem_group2; 
RUN; 
DATA pd2_1990; 
   MERGE out_2_1991(KEEP=dem_group2 percent)
         cpsdata.pd2_72(KEEP=dem_group2 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd2_80(KEEP=dem_group2 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd2_10(KEEP=dem_group2 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group2; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd2_1990; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem2_1990 MEAN=;
RUN; 
PROC SORT DATA=out_3_1991; 
   BY dem_group3; 
RUN; 
DATA pd3_1990; 
   MERGE out_3_1991(KEEP=dem_group3 percent)
         cpsdata.pd3_72(KEEP=dem_group3 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd3_80(KEEP=dem_group3 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd3_10(KEEP=dem_group3 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group3; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd3_1990; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem3_1990 MEAN=;
RUN; 
PROC SORT DATA=out_4_1991; 
   BY dem_group4; 
RUN; 
DATA pd4_1990; 
   MERGE out_4_1991(KEEP=dem_group4 percent)
         cpsdata.pd4_72(KEEP=dem_group4 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd4_80(KEEP=dem_group4 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd4_10(KEEP=dem_group4 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group4; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd4_1990; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem4_1990 MEAN=;
RUN; 
PROC SORT DATA=out_5_1991; 
   BY dem_group5; 
RUN; 
DATA pd5_1990; 
   MERGE out_5_1991(KEEP=dem_group5 percent)
         cpsdata.pd5_72(KEEP=dem_group5 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd5_80(KEEP=dem_group5 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd5_10(KEEP=dem_group5 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group5; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd5_1990; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem5_1990 MEAN=;
RUN; 

* 2000;
PROC SORT DATA=out_1_2001; 
   BY dem_grp; 
RUN; 
DATA pd1_2000; 
   MERGE out_1_2001(KEEP=dem_grp percent)
         cpsdata.pd1_72(KEEP=dem_grp pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd1_80(KEEP=dem_grp pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd1_10(KEEP=dem_grp pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_grp; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd1_2000; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem1_2000 MEAN=;
RUN; 
PROC SORT DATA=out_2_2001; 
   BY dem_group2; 
RUN; 
DATA pd2_2000; 
   MERGE out_2_2001(KEEP=dem_group2 percent)
         cpsdata.pd2_72(KEEP=dem_group2 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd2_80(KEEP=dem_group2 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd2_10(KEEP=dem_group2 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group2; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd2_2000; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem2_2000 MEAN=;
RUN; 
PROC SORT DATA=out_3_2001; 
   BY dem_group3; 
RUN; 
DATA pd3_2000; 
   MERGE out_3_2001(KEEP=dem_group3 percent)
         cpsdata.pd3_72(KEEP=dem_group3 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd3_80(KEEP=dem_group3 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd3_10(KEEP=dem_group3 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group3; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd3_2000; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem3_2000 MEAN=;
RUN; 
PROC SORT DATA=out_4_2001; 
   BY dem_group4; 
RUN; 
DATA pd4_2000; 
   MERGE out_4_2001(KEEP=dem_group4 percent)
         cpsdata.pd4_72(KEEP=dem_group4 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd4_80(KEEP=dem_group4 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd4_10(KEEP=dem_group4 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group4; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd4_2000; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem4_2000 MEAN=;
RUN; 
PROC SORT DATA=out_5_2001; 
   BY dem_group5; 
RUN; 
DATA pd5_2000; 
   MERGE out_5_2001(KEEP=dem_group5 percent)
         cpsdata.pd5_72(KEEP=dem_group5 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd5_80(KEEP=dem_group5 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd5_10(KEEP=dem_group5 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group5; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd5_2000; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem5_2000 MEAN=;
RUN; 

* 2010;
PROC SORT DATA=out_1_2011; 
   BY dem_grp; 
RUN; 
DATA pd1_2010; 
   MERGE out_1_2011(KEEP=dem_grp percent)
         cpsdata.pd1_72(KEEP=dem_grp pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd1_80(KEEP=dem_grp pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd1_10(KEEP=dem_grp pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_grp; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd1_2010; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem1_2010 MEAN=;
RUN; 
PROC SORT DATA=out_2_2011; 
   BY dem_group2; 
RUN; 
DATA pd2_2010; 
   MERGE out_2_2011(KEEP=dem_group2 percent)
         cpsdata.pd2_72(KEEP=dem_group2 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd2_80(KEEP=dem_group2 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd2_10(KEEP=dem_group2 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group2; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd2_2010; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem2_2010 MEAN=;
RUN; 
PROC SORT DATA=out_3_2011; 
   BY dem_group3; 
RUN; 
DATA pd3_2010; 
   MERGE out_3_2011(KEEP=dem_group3 percent)
         cpsdata.pd3_72(KEEP=dem_group3 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd3_80(KEEP=dem_group3 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd3_10(KEEP=dem_group3 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group3; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd3_2010; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem3_2010 MEAN=;
RUN; 
PROC SORT DATA=out_4_2011; 
   BY dem_group4; 
RUN; 
DATA pd4_2010; 
   MERGE out_4_2011(KEEP=dem_group4 percent)
         cpsdata.pd4_72(KEEP=dem_group4 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd4_80(KEEP=dem_group4 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd4_10(KEEP=dem_group4 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group4; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd4_2010; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem4_2010 MEAN=;
RUN; 
PROC SORT DATA=out_5_2011; 
   BY dem_group5; 
RUN; 
DATA pd5_2010; 
   MERGE out_5_2011(KEEP=dem_group5 percent)
         cpsdata.pd5_72(KEEP=dem_group5 pov_cpi_adj_2 RENAME=(pov_cpi_adj_2=pov_at_72))
		 pd5_80(KEEP=dem_group5 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_80 pov_cpi_adj_2=pov_at_80 pov_cpi_adj_5=pov_pt_80))
		 pd5_10(KEEP=dem_group5 pov_cpi_adj_8 pov_cpi_adj_2 pov_cpi_adj_5 RENAME=(pov_cpi_adj_8=pov_10 pov_cpi_adj_2=pov_at_10 pov_cpi_adj_5=pov_pt_10));
   BY dem_group5; 
   ARRAY miss_array percent pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   DO OVER miss_array;
      IF miss_array=. THEN miss_array=0;
   END;
RUN; 
PROC MEANS DATA=pd5_2010; 
   VAR pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
   WEIGHT percent;
   OUTPUT OUT=dem5_2010 MEAN=;
RUN; 



data group2;
   set nas_pov1981 nas_pov1982 nas_pov1983 nas_pov1984 nas_pov1985 
	   nas_pov1986 nas_pov1987 nas_pov1988 nas_pov1989 nas_pov1990;
run;

proc datasets;
   delete nas_pov1981 nas_pov1982 nas_pov1983 nas_pov1984 nas_pov1985 
	      nas_pov1986 nas_pov1987 nas_pov1988 nas_pov1989 nas_pov1990;
run;

proc means data=group2;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g2 MEAN= N=n1;
run;
proc means data=group2;
  where pov1=1;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g2p1 MEAN= N=n1;
run;
proc means data=group2;
  where pov_cpi_adj_8=1;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g2p2 MEAN= N=n1;
run;
proc means data=group2;
  where pov_cpi_adj_2=1;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g2p3 MEAN= N=n1;
run;
proc means data=group2 VARDEF=WGT;
  where year IN(1981);
  var pov1 pov_cpi_adj_8 pov_cpi_adj_2;
  weight msupwgt;
  output out=se_dat80 MEAN= N=n1 STD=std1;
run;


data group3;
   set nas_pov1991 nas_pov1992 nas_pov1993 nas_pov1994 nas_pov1995 
	   nas_pov1996 nas_pov1997 nas_pov1998 nas_pov1999 nas_pov2000;
run;

proc datasets;
   delete nas_pov1991 nas_pov1992 nas_pov1993 nas_pov1994 nas_pov1995 
	      nas_pov1996 nas_pov1997 nas_pov1998 nas_pov1999 nas_pov2000;
run;

proc means data=group3;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g3 MEAN= N=n1;
run;
proc means data=group3;
  where pov1=1;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g3p1 MEAN= N=n1;
run;
proc means data=group3;
  where pov_cpi_adj_8=1;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g3p2 MEAN= N=n1;
run;
proc means data=group3;
  where pov_cpi_adj_2=1;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g3p3 MEAN= N=n1;
run;
proc means data=group3 VARDEF=WGT;
  where year IN(1991);
  var pov1 pov_cpi_adj_8 pov_cpi_adj_2;
  weight msupwgt;
  output out=se_dat90 MEAN= N=n1 STD=std1;
run;


data group4;
   set nas_pov2001 nas_pov2002 nas_pov2003 nas_pov2004 nas_pov2005 nas_pov2006 
	   nas_pov2007 nas_pov2008 nas_pov2009 nas_pov2010 nas_pov2011;
run;

proc datasets;
   delete nas_pov2001 nas_pov2002 nas_pov2003 nas_pov2004 nas_pov2005 nas_pov2006
	      nas_pov2007 nas_pov2008 nas_pov2009 nas_pov2010 nas_pov2011;
run;

proc means data=group4;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g4 MEAN= N=n1;
run;
proc means data=group4;
  where pov1=1;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g4p1 MEAN= N=n1;
run;
proc means data=group4;
  where pov_cpi_adj_8=1;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g4p2 MEAN= N=n1;
run;
proc means data=group4;
  where pov_cpi_adj_2=1;
  var age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids tot_earnrs fpersons_final;
  weight msupwgt;
  output out=g4p3 MEAN= N=n1;
run;
proc means data=group4 VARDEF=WGT;
  where year IN(2001);
  var pov1 pov_cpi_adj_8 pov_cpi_adj_2;
  weight msupwgt;
  output out=se_dat00 MEAN= N=n1 STD=std1;
run;
proc means data=group4 VARDEF=WGT;
  where year IN(2011);
  var pov1 pov_cpi_adj_8 pov_cpi_adj_2;
  weight msupwgt;
  output out=se_dat10 MEAN= N=n1 STD=std1;
run;


filename outfil13 'N:\Private\Poverty Trends\SAS\cps\output\demogr8010.dat';

DATA _null_; 
   SET g2 g3 g4 g2p1 g3p1 g4p1 g2p2 g3p2 g4p2 g2p3 g3p3 g4p3;
   FILE outfil13 lrecl=1500 pad; 
   PUT age1-age3 r1-r3 region1-region4 fam1-fam5 ownhome ed1-ed4 emp_head tot_kids 
	   tot_earnrs fpersons_final n1;
RUN; 

filename outfil15 'N:\Private\Poverty Trends\SAS\cps\output\dem_pov6410.dat';

DATA _null_; 
   SET dem1_1963 dem2_1963 dem3_1963 dem4_1963 dem5_1963
	   dem1_1972 dem2_1972 dem3_1972 dem4_1972 dem5_1972
	   dem1_1980 dem2_1980 dem3_1980 dem4_1980 dem5_1980
	   dem1_1990 dem2_1990 dem3_1990 dem4_1990 dem5_1990
	   dem1_2000 dem2_2000 dem3_2000 dem4_2000 dem5_2000
	   dem1_2010 dem2_2010 dem3_2010 dem4_2010 dem5_2010;
   FILE outfil15 lrecl=1500 pad; 
   PUT pov_80 pov_10 pov_at_72 pov_at_80 pov_at_10 pov_pt_80 pov_pt_10;
RUN; 

filename outfil14 'N:\Private\Poverty Trends\SAS\cps\output\means_w_se.dat';

DATA _null_; 
   SET se_dat80 se_dat90 se_dat00 se_dat10;
   FILE outfil14 lrecl=500 pad; 
   PUT pov1 pov_cpi_adj_8 pov_cpi_adj_2 n1 std1;
RUN; 
